#!/bin/sh

INSTALL=$1
LAUNCH_PLIST="$2"
CPUSETTER="$3"
SETTINGS="$4"

LAUNCHCTL="/bin/launchctl"
LAUNCHDAEMONS="/Library/LaunchDaemons"
APPSUPPORT="/Library/Application Support/CPUSetter"
LABEL="net.whatroute.bootcpusetter"

install()
{
	mkdir -p "${APPSUPPORT}"
	cp "${CPUSETTER}" "${APPSUPPORT}"

	cat <<EOF > "${APPSUPPORT}"/bootsettings.sh
#!/bin/sh
#
# DO NOT EDIT THIS FILE
# File was generated by CPUSetter (https://whatroute.net/cpusetter.html)
# and your changes will be overwritten.
#
# Use CPUSetter to configure or uninstall this service.
#
EOF
	echo \"${APPSUPPORT}\"/cpusetter ${SETTINGS} >> "${APPSUPPORT}"/bootsettings.sh
	chown root:wheel "${APPSUPPORT}"/bootsettings.sh
	chmod 0755 "${APPSUPPORT}"/bootsettings.sh

	chown root:wheel "${APPSUPPORT}"/*

	cp "${LAUNCH_PLIST}" ${LAUNCHDAEMONS}/${LABEL}.plist
	chown root:wheel ${LAUNCHDAEMONS}/${LABEL}.plist

	${LAUNCHCTL} load -w ${LAUNCHDAEMONS}/${LABEL}.plist
}

uninstall()
{
	${LAUNCHCTL} unload ${LAUNCHDAEMONS}/${LABEL} 2> /dev/null
	rm -f ${LAUNCHDAEMONS}/${LABEL}.plist
	rm -rf "${APPSUPPORT}"
}

case ${INSTALL} in
	"install")
		install
		;;
	"uninstall")
		uninstall
		;;
	*)
		echo "Unknown option: ${INSTALL}"
		exit 1
		;;
esac
exit 0
