#!/bin/sh

DIR=$1

CURL=/usr/bin/curl
GUNZIP=/usr/bin/gunzip

URL=http://geolite.maxmind.com/download/geoip/database/GeoLite2-City.mmdb.gz

DL=$DIR/tmp.data
DB=$DIR/GeoLite2-City.mmdb

rm -f $DL

$CURL -o $DL -s $URL

if [ $? != 0 ]; then
	echo "Problem downloading MaxMind data: $URL"
	exit 1
fi

mv $DL $DB.gz

if [ -e $DB ]; then
	mv $DB $DB.old
fi

$GUNZIP $DB.gz
echo "MaxMind data installed: $DB"
