#!/bin/sh

#  neighbours.sh
#  WhatRoute2
#
#  Created by Bryan Christianson on 16/04/16.
#  Copyright © 2016 Rodney Truck Parts Ltd. All rights reserved.


showV6=false
showV4=false

while test ${#} -gt 0
do
	if [ $1 = "-6" ]; then
		showV6=true
	fi

	if [ $1 = "-4" ]; then
		showV4=true
	fi

	shift
done

NDP=/usr/sbin/ndp
ARP=/usr/sbin/arp
AWK=/usr/bin/awk

if [ $showV6 = "true" ]; then
	#
	# IPv6 neighbours

	${NDP}  -na | grep -vi incomplete | grep -vi neighbor | \
		${AWK} '
		{
			interface = $3
			mac = $2
			ip = $1
			printf("ipv6 %s %s %s\n", interface, mac, ip)
		}'
fi

if [ $showV4 = "true" ]; then
	#
	# IPv4 neighbours

	${ARP} -na | grep -vi incomplete | \
		${AWK} '
		{
			interface = $6
			mac = $4
			ip = $2
			ip = substr(ip, 2)
			ip = substr(ip, 1, length(ip) - 1)
			printf("ipv4 %s %s %s\n", interface, mac, ip)
		}'
fi