#!/bin/sh

#  refreshbogonlist.sh
#  WhatRoute2
#
#  Created by Bryan Christianson on 13/03/16.
#  Copyright © 2016 Rodney Truck Parts Ltd. All rights reserved.


src_url=$1
dst_dir=$2

CURL=/usr/bin/curl

file=$(basename $src_url)
dst=$dst_dir/$file

if [ -f $dst ]; then
	last_update=$(head -1 $dst | awk '{print $4}')
	# echo "last_update: $last_update"

	now=$(date "+%s")
	# echo "now: $now"

	age=$(( $now - $last_update ))
	# echo "age: $age"

	max_age=$(( 3600 * 24 ))
	# echo "max_age: $max_age"

	if [ "$age" -le "$max_age" ]; then
		# echo "No update required"
		exit 0
	fi
fi

mkdir -p $dst_dir

echo "Updating bogon data: $CURL -s -o $dst.download $src_url"
$CURL -s -o $dst.download $src_url

if [ $? != 0 ]; then
	echo "failed: $CURL -s -o $dst $src_url"
	exit 1
fi

mv $dst.download $dst_dir/$file

